/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.blocks;

import com.minecolonies.api.blocks.huts.AbstractBlockMinecoloniesDefault;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockScarecrow
extends AbstractBlockMinecoloniesDefault<BlockScarecrow> {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;

    public BlockScarecrow() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(10.0f, 10.0f));
        this.setRegistryName("blockhutfield");
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @NotNull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197873_a((double)0.1f, (double)((float)(0.0 - (double)(state.func_177229_b(HALF) == DoubleBlockHalf.UPPER ? 1 : 0))), (double)0.1f, (double)0.9f, (double)((float)(2.2 - (double)(state.func_177229_b(HALF) == DoubleBlockHalf.UPPER ? 1 : 0))), (double)0.9f);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ScarecrowTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (!worldIn.field_72995_K) {
            DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
            TileEntity entity = worldIn.func_175625_s(half == DoubleBlockHalf.UPPER ? pos.func_177977_b() : pos);
            if (entity instanceof ScarecrowTileEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((ScarecrowTileEntity)entity), (BlockPos)pos);
            } else {
                return ActionResultType.FAIL;
            }
        }
        return ActionResultType.SUCCESS;
    }

    @javax.annotation.Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction dir;
        Direction direction = dir = context.func_195999_j() == null ? Direction.NORTH : Direction.func_176733_a((double)(context.func_195999_j().field_70177_z + 180.0f));
        if (context.func_195995_a().func_177956_o() < 255 && context.func_195991_k().func_180495_p(context.func_195995_a().func_177984_a()).func_196953_a(context)) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)dir)).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return blockstate.func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP);
        }
        return blockstate.func_177230_c() == this;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        ScarecrowTileEntity scareCrow;
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
        if (worldIn.field_72995_K) {
            return;
        }
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, pos);
        if (colony != null && (scareCrow = (ScarecrowTileEntity)worldIn.func_175625_s(pos)) != null) {
            colony.getBuildingManager().addNewField(scareCrow, pos, worldIn);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        BlockScarecrow.notifyColonyAboutDestruction((IWorld)worldIn, pos);
        super.func_180652_a(worldIn, pos, explosionIn);
    }

    public void func_176208_a(World worldIn, @NotNull BlockPos pos, BlockState state, @NotNull PlayerEntity player) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        BlockPos otherpos = half == DoubleBlockHalf.LOWER ? pos.func_177984_a() : pos.func_177977_b();
        BlockState otherstate = worldIn.func_180495_p(otherpos);
        if (otherstate.func_177230_c() == this && otherstate.func_177229_b(HALF) != half) {
            worldIn.func_180501_a(otherpos, Blocks.field_150350_a.func_176223_P(), 35);
        }
        BlockScarecrow.notifyColonyAboutDestruction((IWorld)worldIn, pos);
        super.func_176208_a(worldIn, pos, state, player);
    }

    private static void notifyColonyAboutDestruction(IWorld worldIn, BlockPos pos) {
        IColony colony;
        if (!worldIn.func_201670_d() && (colony = IColonyManager.getInstance().getColonyByPosFromWorld((World)worldIn, pos)) != null) {
            colony.getBuildingManager().removeField(pos);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HALF, FACING});
    }

    public boolean hasTileEntity(BlockState state) {
        return state.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
    }
}

